clc, clear
LibO = myOutputFile;
LibI = myInterfacciaDAQ;
LibT = myTdmsReader;
Zero = [2.872748438 -0.088105225];

%%
% REAR
% d/L = 50% n600: (37) (77) (87)
% d/L = 50% n800: (39) (79) (89)

% FRONT
% d/L =-50% n600: (47) (67) (57)
% d/L =-50% n800: (49) (69) (59)

%%
nVet = 500:100:900;
CDalone = [0.3144	0.3810	0.4292	0.4654	0.4941];

dCDfront = [0.25	0.0202	-0.0083	-0.014	-0.0303	-0.0296
    0.5	-0.0105	-0.0454	-0.0657	-0.0792	-0.0924
    0.75	0.0017	-0.0324	-0.044	-0.0516	-0.0646
    1.0	0.0177	-0.0019	-0.0105	-0.0221	-0.029
    1.5	0.0387	0.0165	0.0087	0.0058	0.0042
    2.0	0.052	0.0378	0.0266	0.0196	0.015
    3.0	0.0155	0.009	0.0079	0.0049	0.0026
    4.0	0.0165	0.0101	0.0032	0.002	0.0011
    5.0	0.0147	0.0055	0.0055	0	-0.0008
    6.0	0.012	0.0059	0.0026	-0.0002	-0.0018
    7.0	0.0088	0.0026	0.0018	-0.0022	-0.003
    9.27	0.0063	-0.0024	-0.0029	-0.0053	-0.0056];
dCDfront(:,1) = -dCDfront(:,1);

dCDrear = [0 zeros(1,5)
    0.25	-0.1529	-0.1827	-0.2007	-0.2144	-0.2194
    0.5	-0.1423	-0.1744	-0.1945	-0.2076	-0.2159
    0.75	-0.0833	-0.1027	-0.1246	-0.144	-0.1627
    1.0	-0.0887	-0.1103	-0.1426	-0.1563	-0.1643
    1.5	-0.1122	-0.1334	-0.1466	-0.1555	-0.164
    2.0	-0.1008	-0.1248	-0.1375	-0.1458	-0.1564
    3.0	-0.0951	-0.1131	-0.122	-0.1315	-0.1349
    3.5	-0.0602	-0.0858	-0.0998	-0.1131	-0.1219
    4.15	-0.0504	-0.0746	-0.0896	-0.1031	-0.114];

dCD = [flipud(dCDfront); dCDrear];
interpPlatoon = @(n,d) CDalone(nVet==n)+[0 dCD(dCD(:,1)==d,[nan nVet]==n)];

%%
ss = cell(3,1);
for K = 1%:3
    ss{K} = LibO.txt2struct([],[],"Scegli file n°"+K);
end

%%
leggi = @(s) str2num(replace(regexp(s,'(\-)?[\d\.]{2,}(%)?','match')+"",'%','/100')); %#ok<*ST2NM>
%f = figure('Color','w');

% %%
% for K=1:3

s = ss{K};
[slc, tlc, ~] = LibO.extractFromFile( s.loa );
[smi, tmi, ~] = LibO.extractFromFile( s.mics );
if ss{1}.valid(3)
    [sge, tge, tags] = LibO.extractFromFile( s.get );
end

nor = @(m) rescale(m,'InputMin',5.5,'InputMax',9.5);
mm = [6,9,16];

micMode = 1;    %(0)timeline, (1)frequency
filterMic = 1;  %(0) no filter, (1) yes filter

if filterMic
    windowCoeff = load('secondo_grup.mat').G2;
    windowCoeff(:,1:8) = load('primo_grup.mat').G1;
    smi = smi - mean(smi);
    for i=1:size(smi,2)
        smi(:,i) = filter( windowCoeff(:,i),1, smi(:,i) ) * 10;
    end
end

f = figure('name',ss{1}.note,'Color','w');
maxF = 100;

if 1; ss{1}.valid(3)
    note = importdata(s.note,'s');
    note{3} = replace(note{3},'Elica','Propeller');
    Uinf = ''; %leggi(note{end-2});
    Rey  = '5 values'; %Uinf*1.225*0.17/1.5;
    appunti = [note([3 5 6]); {['Re = ' Rey]}]; %{sprintf('Re = %.3f x 10^5',Rey)}
    %
    %     xlim([0 1])
    %     ax=gca; ax.XColor = 'none'; ax.YColor='none';
    
    n = 0; %leggi(note{3});
    try
        dL= leggi(note{5});
        if dL >0
            appunti = [{'(Rear Platooning)'}; appunti];
        else
            appunti = [{'(Front Platooning)'}; appunti];
        end
    catch
        dL = 'none';
        appunti = [{'(Isolated Truck)'}; appunti];
    end
    
    subplot(4,1,1)
%     plot(tge, nor(sge(1:length(tge),:)),'-'), hold on,
%     xlim(tge([1 end]))
%     plot(tlc,slc(:,1),'-')
%     
%     
%     out = LibT.computeCd( slc(:,[1 4]), [], Zero);
%     CDpre  = mean(out.Cd(tlc<=25));
%     CDpost = mean(out.Cd(tlc> 25));
%     plot(tlc,out.Cd,':')
%     plot([0 25*[1 1] tlc(end)],[CDpre CDpre CDpost CDpost],'--k')
%     ll = legend('VariableNames',["[%] Top" "[%] Bot",...
%         "[%] Side" "[V] LC" "CD_{istantaneous}" "\DeltaCD: "+round(CDpost-CDpre,3)]);
%     ll.ItemHitFcn = @myTdmsReader.ShowOnOff;
    set(gca,'Tag','uno')
    hold on
    title('Jet Signals and Drag of the Test')
    
    
    tt= text(35+0.5,0.5,appunti,'Ver','bot','fontsize',8); hold on
    
    tt.ButtonDownFcn = @move;
end

tipi = ["Top" "Side" "Bot"]+" Mic";
for i=1:3
    subplot(4,1,i+1)
    [wt,fr,coi] = cwt(smi(:,mm(i)),nnz(tmi<1));
    pcolor(tmi',fr(fr<=maxF),abs(wt(fr<=maxF,:)));
    shading interp; hold on
    colormap('turbo')
    co=colorbar; ylabel({tipi(i); 'Frequency [Hz]'})
    co.Title.String = 'Magnitude';
    switch i
        case 1, title('Rear-Truck Pressure Wavelet Transform')
        case 3, xlabel('Time [s]')
    end
    maxMagnitude=max(abs(wt(fr<=maxF,:)),[],'all')
    %    caxis([0 10])
    drawnow
end

% linkaxes(f.Children(2:2:end),'x')
% linkaxes(f.Children(2:2:end-1),'y')

xlim(25 +[-1 1]*6)
primo = @(x) x(2);
tt.Position(1) = primo(get(gca,'XLim'))+0.2;
ylim([0 60])

function move(src,~)
oo = gca;
ff = gcf;
yesMove = true;
ff.WindowButtonMotionFcn = @sposta;
ff.WindowButtonUpFcn = @kill;

    function sposta(~,~)
        if yesMove
            src.Position(1:2) = oo.CurrentPoint(1,1:2);
        end
    end
    function kill(~,~)
        yesMove = false;
    end
end